/******************************************************************************
* File:    hscmp_util.c
*
* Purpose: Provide common utilities used for hfm testing.
* Author:  Neha Jain, Freescale Semiconductor
* Email:   neha.jain@freescale.com
* Date:    2007.06.08
******************************************************************************/

#include "util.h"
#include "intrinsics_56800E.h"
#include "lib_sci.h"
#include "lib_utils.h"

uint8_t input_no,number;
// Function Prototype
void enable_hawk_interrupts(void);
void configure_port_cmp0(uint8_t input_no);
void configure_port_cmp1(uint8_t input_no);
void configure_port_cmp2(uint8_t input_no);
void configure_output_port_cmp0(uint8_t number);
void configure_output_port_cmp1(uint8_t number);
void configure_output_port_cmp2(uint8_t number);
void go_to_stop_mode();
void go_to_lpwait_mode();
void go_to_wait_mode();
void go_to_lpstop_mode();

/*   Function definition section    */

/******************************************************************************
* enable_hawk_interrupts() 
* This function enables hawk interrupts.
* 
*****************************************************************************/
void enable_hawk_interrupts() {
   PrintInfo2("hscmp_util():", "Enable enable_hawk_interrupts");
   asm(moveu.w #$0000,sr);
}   


void configure_port_cmp0(uint8_t input_no)
{
   SHOW16("hscmp_util():", "Configuring for CMP0 Channel :", input_no);
   switch (input_no)
   {
      case 0x00 :
        PrintInfo2("hscmp_util()", "Channel Selected : 0 (GPIOE1,GPIOE2)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOE_PER, GPIOE_PER_PER_1);
        BSET16(GPIOE_PER, GPIOE_PER_PER_2);
        break;
      
      case 0x01 :
        PrintInfo2("hscmp_util()", "Channel Selected : 1 (GPIOB6,GPIOC4)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOB_PER, GPIOB_PER_PER_6);
        BSET16(GPIOC_PER, GPIOC_PER_PER_4);  
        //SIM_GPSB6 configured for cmp0_p2   field value =2'b10
        //configuring SIM_GPSB1
         BSET16(SIM_GPSB1, SIM_GPSB1_GPS_B6_1);

        break;
     
      case 0x02 :
        PrintInfo2("hscmp_util()", "Channel Selected : 2 (GPIOF3,GPIOF2)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOF_PER, GPIOF_PER_PER_3);
        BSET16(GPIOF_PER, GPIOF_PER_PER_2);
        break;

      case 0x03 :
        PrintInfo2("hscmp_util()", "Channel Selected : 3 (GPIOC5,ipp_vssa)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOC_PER, GPIOC_PER_PER_5);
        break;

         
    }
    PrintInfo2("hscmp_util()", "Port Configuration for CMP0 done!!");
}

void configure_port_cmp1(uint8_t input_no)
{
   SHOW16("hscmp_util():", "Configuring for CMP1 Channel :", input_no);
   switch (input_no)
   {
      case 0x00 :
        PrintInfo2("hscmp_util()", "Channel Selected : 0 (GPIOC6,GPIOC0)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOC_PER, GPIOC_PER_PER_6);
        BSET16(GPIOC_PER, GPIOC_PER_PER_0);
        //clearing the SIM_GPSC0 register first field value =1'b0
        BCLR16(SIM_GPSC,SIM_GPSC_GPS_C0);
        break;
      
      case 0x01 :
        PrintInfo2("hscmp_util()", "Channel Selected : 1 (GPIOD2,GPIOC7)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOD_PER, GPIOD_PER_PER_2);
        BSET16(GPIOC_PER, GPIOC_PER_PER_7);
		//SIM_GPDS2 =2'b01
        BSET16(SIM_GPSD, SIM_GPSD_GPS_D2_0);
        break;
     
      case 0x02 :
        PrintInfo2("hscmp_util()", "Channel Selected : 2 (GPIOF1,GPIOE7)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOF_PER, GPIOF_PER_PER_1);
        BSET16(GPIOE_PER, GPIOE_PER_PER_7);
        break;
    }

   PrintInfo2("hscmp_util()", "Port Configuration for CMP1 done!!");
}


void configure_port_cmp2(uint8_t input_no)

{
   SHOW16("hscmp_util():", "Configuring for CMP2 Channel :", input_no);
   switch (input_no)
   {
      case 0x00 :
        PrintInfo2("hscmp_util()", "Channel Selected : 0 (GPIOE5,GPIOE3)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOE_PER, GPIOE_PER_PER_3);
        BSET16(GPIOE_PER, GPIOE_PER_PER_5);
        break;
      
      case 0x01 :
        PrintInfo2("hscmp_util()", "Channel Selected : 1 (GPIOE4,GPIOC1)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOE_PER, GPIOE_PER_PER_4);
        BSET16(GPIOC_PER, GPIOC_PER_PER_1);
        break;
     
      case 0x02 :
        PrintInfo2("hscmp_util()", "Channel Selected : 2 (GPIOB1,GPIOB7)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOB_PER, GPIOB_PER_PER_1);
        BSET16(GPIOB_PER, GPIOB_PER_PER_7);
        BSET16(SIM_GPSB1,SIM_GPSB1_GPS_B7_1); //SIM_GPSB7=2'b10
        BSET16(SIM_GPSB0,SIM_GPSB0_GPS_B1_1); //SIM_GPSB1=2'b10
        break;

      case 0x03 :
        PrintInfo2("hscmp_util()", "Channel Selected : 3 (GPIOC2,ipp_vssa)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOC_PER, GPIOC_PER_PER_2);
        break;

         
    }
    PrintInfo2("hscmp_util()", "Port Configuration for CMP2 done!!");
}


void configure_output_port_cmp0(uint8_t number)
{
    switch(number)
    {
    case 0x00 :
     PrintInfo2("hscmp_util()", "Channel : 0 Output : (GPIOB2)");
        //first configuring GPIOB_PER register to enable peripheral functionality
        BSET16(GPIOB_PER, GPIOB_PER_PER_2);
        //clearing the SIM_GPSE0 register first field value = 11
        BSET16(SIM_GPSB0,SIM_GPSB0_GPS_B2);
        break;

    case 0x01 :
       PrintInfo2("hscmp_util()", "Channel : 0 Output : (TDI:GPIOD0)");
        //first configuring GPIOD_PER register to enable peripheral functionality
        BSET16(GPIOD_PER, GPIOD_PER_PER_0);
        //BSET16(GPIOE_PER, GPIOE_PER_PER_2);
        //clearing the SIM_GPSE0 register first  field value = 100
		BCLR16(SIM_GPSD,SIM_GPSD_GPS_D0);
        BSET16(SIM_GPSD,SIM_GPSD_GPS_D0_2);
        break;
     }
    PrintInfo2("hscmp_util()","Output port configured for CMP0");
   
}

void configure_output_port_cmp1(uint8_t number)
{
    switch(number)
    {
    case 0x00 :
     PrintInfo2("hscmp_util()", "Channel : 0 Output : ( TMS : GPIOD3)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOD_PER, GPIOD_PER_PER_3);
        
        //SIM_GPSD3 fiel value = 2'b11
        BSET16(SIM_GPSD,SIM_GPSD_GPS_D3_0 | SIM_GPSD_GPS_D3_1);
        break;

    case 0x01 :
       PrintInfo2("hscmp_util()", "Channel : 1 Output : (GPIOB3)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOB_PER, GPIOB_PER_PER_3);
        
        //setting SIM_GPS0B register, field value = 100
        BCLR16(SIM_GPSB0,SIM_GPSB0_GPS_B3);
        BSET16(SIM_GPSB0,SIM_GPSB0_GPS_B3_2);
        break;
     }
    PrintInfo2("hscmp_util()","Output port configured for CMP1");
   
}

void configure_output_port_cmp2(uint8_t number)
{
	switch(number)
	{
	case 0x00 :
      PrintInfo2("hscmp_util()", "Channel : 2 Output : (TDO : GPIOD1)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOD_PER, GPIOD_PER_PER_1);
        //clearing the SIM_GPSD register first field value = 2'b11
        BSET16(SIM_GPSD,SIM_GPSD_GPS_D1_0 | SIM_GPSD_GPS_D1_1);
		break;

     case 0x01 :
      PrintInfo2("hscmp_util()", "Channel : 2 Output : (TCK : GPIOD2)");
        //first configuring GPIO_PER register to enable peripheral functionality
        BSET16(GPIOD_PER, GPIOD_PER_PER_2);
        //setting SIM_GPSD2 register, field value = 2'b10
        BCLR16(SIM_GPSD,SIM_GPSD_GPS_D2_0);
        BSET16(SIM_GPSD,SIM_GPSD_GPS_D2_1);
    	break;	
	}
    
    PrintInfo2("hscmp_util()","Output port configured for CMP2");
   
}

void go_to_stop_mode()
{
    PrintInfo2("STOP:","Clear LPR bit in PMC_SCR");
	BCLR16(PMC_SCR,PMC_SCR_LPR);  //so after wakeup go into RUN and not LPRUN
	read_expect_mask(&PMC_SCR,0x0000,PMC_SCR_LPR|PMC_SCR_LPRS);
	//check LVDE is set
	read_expect_mask(&PMC_SCR,0x0008,PMC_SCR_LVDE);  //LVD logic detection enabled
	read_expect_mask(&SIM_CTRL,0x0000,SIM_CTRL_STOP_disable_0);
    PrintInfo2("STOP:","Calling intrinsic stop function");
	stop();

}

void go_to_lpwait_mode()
{ 
   PrintInfo2("LPWAIT:","Clear LVDE bit in PMC_SCR");
	BCLR16(PMC_SCR,PMC_SCR_LVDE);
	read_expect_mask(&PMC_SCR,0x0000,PMC_SCR_LVDE);
   PrintInfo2("LPWAIT:","SET LPR bit in PMC_SCR");
	BSET16(PMC_SCR,PMC_SCR_LPR);
   PrintInfo2("LPWAIT:","Wait for LPRS bit to get set in PMC_SCR");
	WAIT_REM16(PMC_SCR,0x00C0,PMC_SCR_LPR|PMC_SCR_LPRS,0x20);
	read_expect_mask(&SIM_CTRL,0x0000,SIM_CTRL_WAIT_disable_0);
   PrintInfo2("LPWAIT:","intrinsic wait function called");
	wait();
}

void go_to_wait_mode()
{ 
   	PrintInfo2("WAIT:","Clear LPR bit in PMC_SCR");
	BCLR16(PMC_SCR,PMC_SCR_LPR);
	read_expect_mask(&PMC_SCR,0x0000,PMC_SCR_LPR|PMC_SCR_LPRS);
	//check LVDE is enabled
	read_expect_mask(&PMC_SCR,0x0008,PMC_SCR_LVDE);
	read_expect_mask(&SIM_CTRL,0x0000,SIM_CTRL_WAIT_disable_0);
	PrintInfo2("WAIT:","Calling intrinsic wait function");
	wait();

}

void go_to_lpstop_mode()
{
   //LVDE=0,PPDE=0,LPR=1,low frequency is reqd    

	PrintInfo2("LPSTOP:","Clear LVDE bit in PMC_SCR");
	BCLR16(PMC_SCR,PMC_SCR_LVDE);
	read_expect_mask(&PMC_SCR,0x0000,PMC_SCR_LVDE);
	PrintInfo2("LPSTOP:","SET LPR bit in PMC_SCR");
	BSET16(PMC_SCR,PMC_SCR_LPR);
	PrintInfo2("LPSTOP:","Wait for LPRS bit to get set in PMC_SCR");
	WAIT_REM16(PMC_SCR,0x00C0,PMC_SCR_LPR|PMC_SCR_LPRS,0x20);
	read_expect_mask(&SIM_CTRL,0x0000,SIM_CTRL_STOP_disable_0);
	PrintInfo2("LPSTOP:","Calling intrinsic stop function");
	stop();


}
